/*jslint node: true, nomen: true, unparam: true */
/*global jquery, $, _, define, Marionette, jqm, window */

'use strict';

define([ 'Portal', 'backbone', 'marionette', 'jquery', 'core/models/Model', 'modules/alerts-list/alertsListItemView', 'hbs!modules/alerts-list/alertsList'],
    function (Portal, Backbone, Marionette, $, Model, AlertsListItemView, template) {
        return Backbone.Marionette.CompositeView.extend({
            template : template,
            itemView: AlertsListItemView,
            itemViewContainer: "#alerts-list-toplist",
            initialize : function () {
                var self = this;
                Portal.commands.setHandler("open-alerts-list", function(){
                    self.openAlertsList();
                });
                Portal.vent.on('close:popups', function () {
                    self.closeMessages();
                }); 
                $(Portal.alertsListRegion.el).popup({
                    positionTo: "#alerts-list",   // The anchor the popup is attached too.
                    shadow: true,                  // Shadow around popup
                    transition: "fade",              // How to animate in.
                    corners: false,                 // No rounded Edges
                    tolerance: "41,0",              // Edges from window
                    dismissible: true               // Click anywhere to close.
                });
            },
            openAlertsList: function () {
                this.$el.trigger('create');
                $(Portal.alertsListRegion.el).popup('open');

                // save latest date
                if (this.collection.length > 0) {
                    localStorage.setItem('last-alert-date', this.collection.models[0].get('date'));
                }

            },
            closeMessages: function (e) {
                $(Portal.alertsListRegion.el).popup('close');
            }
        });
    });
